import { createSlice } from "@reduxjs/toolkit";

const initialState = {
    priceData: {},
    selectedProducts: [],
};

const selectForOrder = createSlice({
    name: "selectForOrder",
    initialState,
    reducers: {
        setOrderData: (state, { payload }) => {
            state.priceData = payload.priceData;
            state.selectedProducts = payload.selectedProducts;
        },
        resetOrderData: (state) => {
            state.priceData = {};
            state.selectedProducts = [];
        },
    },
});

export const { setOrderData, resetOrderData } = selectForOrder.actions;
export default selectForOrder.reducer;
